-- This actor is duplicated.  Upvalues will not be duplicated.

local grades = {
	Grade_Tier01 = 0;
	Grade_Tier02 = 1;
	Grade_Tier03 = 2;
	Grade_Tier04 = 3;
	Grade_Tier05 = 4;
	Grade_Tier06 = 5;
	Grade_Tier07 = 6;
	Grade_Tier08 = 7;
	Grade_Tier09 = 8;
	Grade_Tier10 = 9;
	Grade_Tier11 = 10;
	Grade_Tier12 = 11;
	Grade_Tier13 = 12;
	Grade_Tier14 = 13;
	Grade_Tier15 = 14;
	Grade_Tier16 = 15;
	Grade_Tier17 = 16;
	Grade_Failed = 17;
	Grade_None = 18;
};
local t = Def.ActorFrame {}

t[#t+1] = LoadActor("grades") .. {
	InitCommand=cmd(pause);
	SetGradeCommand=function(self, params)
		local state = grades[params.Grade] or grades['Grade_None'];
		if state then
			self:visible( true );
			self:setstate(state);
		else
			self:visible( false );
		end;
	end;
};


local st = GAMESTATE:GetCurrentStyle():GetStepsType();

-- BestScore List
local function GetProfileHighScores(pn)
	local profile = PROFILEMAN:GetProfile(pn);
	if GAMESTATE:IsCourseMode() then
		local course = GAMESTATE:GetCurrentCourse();
		local Trail = GAMESTATE:GetCurrentTrail(pn);
		scorelist = profile:GetHighScoreList(course,Trail);
	else
		local song = GAMESTATE:GetCurrentSong()
	--	local diff = GAMESTATE:GetCurrentSteps(pn):GetDifficulty()
		local diff = getenv("GetDifficulty"..ToEnumShortString(pn))
		local steps = song:GetOneSteps( st, diff );
		scorelist = profile:GetHighScoreList(song,steps);
	end;
--	assert(scorelist);
	return scorelist:GetHighScores();
end;

-- TopScore List
local function GetMachineHighScores(pn)
	local profile = PROFILEMAN:GetMachineProfile();
	if GAMESTATE:IsCourseMode() then
		local course = GAMESTATE:GetCurrentCourse();
		local Trail = GAMESTATE:GetCurrentTrail(pn);
		scorelist = profile:GetHighScoreList(course,Trail);
	else
		local song = GAMESTATE:GetCurrentSong()
		local diff = getenv("GetDifficulty"..ToEnumShortString(pn))
		local steps = song:GetOneSteps( st, diff );
		scorelist = profile:GetHighScoreList(song,steps);
	end;
	return scorelist:GetHighScores();
end;

-- BestScore List 2
local function GetProfileHighScores2(pn,params)
	local profile = PROFILEMAN:GetProfile(pn);
	if GAMESTATE:IsCourseMode() then
		local course = params.Course;
		local Trail = GAMESTATE:GetCurrentTrail(pn);
		scorelist = profile:GetHighScoreList(course,Trail);
		assert(scorelist);
	else
		local song = params.Song
		local diff = getenv("GetDifficulty"..ToEnumShortString(pn))
		if song:HasStepsTypeAndDifficulty(st,diff) then
			local steps = song:GetOneSteps( st, diff );
			scorelist = profile:GetHighScoreList(song,steps);
			assert(scorelist);
		else
			return nil;
		end;
	end;
	return scorelist:GetHighScores();
end; 

-- TopScore List 2
local function GetMachineHighScores2(pn,params)
	local profile = PROFILEMAN:GetMachineProfile();
	if GAMESTATE:IsCourseMode() then
		local course = params.Course;
		local Trail = GAMESTATE:GetCurrentTrail(pn);
		scorelist = profile:GetHighScoreList(course,Trail);
		assert(scorelist);
	else
		local song = params.Song
		local diff = getenv("GetDifficulty"..ToEnumShortString(pn))	
		if song:HasStepsTypeAndDifficulty(st,diff) then
			local steps = song:GetOneSteps( st, diff );
			scorelist = profile:GetHighScoreList(song,steps);
			assert(scorelist);
		else
			return nil;
		end;
	end;
	return scorelist:GetHighScores();
end;

local bsong;
local b2song;

--[[
-- FullCombo label side
t[#t+1] = LoadActor("FCRing") .. {
	InitCommand=cmd(pause;x,8;y,4;spin;zoom,0.5);
	SetMessageCommand=function(self,params)
		self:visible( false );
		local scores;
		if PROFILEMAN:IsPersistentProfile(pn) then
			scores = GetProfileHighScores2(pn,params);
		else
			self:visible( true );
			scores = GetMachineHighScores2(pn,params);
		end;
		local topscore;
		local bestscore = 0;
		local list = 1;
		if scores ~= nil and scores[1] then
			if GAMESTATE:IsCourseMode() then
				topscore = scores[1];
				local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
				local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
				local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
				local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
				local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")
				if topscore:GetScore() > 0 and scores[1]:GetGrade() ~= "Grade_Tier17" then
					if (misses+boos+goods) == 0 then
						if (greats+perfects) == 0 then
							self:diffuse(color("#ffffee"));
							self:visible( true );
						elseif (greats) == 0 then
							self:diffuse(color("#fafc44"));
							self:visible( true );
						else
							self:diffuse(color("#06fd32"));
							self:visible( true );
						end;
					else

					end;

				else
				end;
			else
				local song = params.Song
				local diff = getenv("GetDifficulty"..ToEnumShortString(pn))
				local steps = song:GetOneSteps( st, diff );

				for i = 1, #scores do
					if scores[i] then
						local bestscore2 = GetSN2Score(pn,steps,scores[i]);
						if bestscore2 > bestscore then
							bestscore = bestscore2;
							list = i;
						end;
					else
						break;
					end;
				end;
					topscore = scores[list];
				local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
				local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
				local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
				local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
				local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")
				if bestscore > 0 and topscore:GetGrade() ~= "Grade_Tier17" and topscore:GetGrade() ~= "Grade_Failed" and topscore:GetGrade() ~= "Grade_None" then
					if (misses+boos+goods) == 0 then
						if (greats+perfects) == 0 then
							self:diffuse(color("#ffffee"));
							self:visible( true );
						elseif (greats) == 0 then
							self:diffuse(color("#fafc44"));
							self:visible( true );
						else
							self:diffuse(color("#06fd32"));
							self:visible( true );
						end;
					else
						
					end;
				else
					
				end;
			end;
		else
			
		end;
		end;
	};
--]]


return t;

-- (c) 2007 Glenn Maynard
-- All rights reserved.
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a
-- copy of this software and associated documentation files (the
-- "Software"), to deal in the Software without restriction, including
-- without limitation the rights to use, copy, modify, merge, publish,
-- distribute, and/or sell copies of the Software, and to permit persons to
-- whom the Software is furnished to do so, provided that the above
-- copyright notice(s) and this permission notice appear in all copies of
-- the Software and that both the above copyright notice(s) and this
-- permission notice appear in supporting documentation.
-- 
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
-- OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
-- MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
-- THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
-- INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
-- OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
-- OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
-- OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
-- PERFORMANCE OF THIS SOFTWARE.
